import React, {Component} from 'react';
import PropTypes from 'prop-types';
import UsersList from "./UsersList";
import {compose} from "redux";
import {graphql} from "react-apollo";
import {authUserQuery, usersQuery} from "../../../../api/queries";

export class UsersListContainer extends Component {

  constructor(props) {
    super(props)
  }

  render() {
    return (
      <UsersList {...this.props} />
    )
  }
}

export default compose(
  graphql(usersQuery, {
    variables: {
      filtro: "",
      pagination: {
        limit: 50, offset: 0
      }
    }
  }),
  graphql(authUserQuery, {name: 'utenteSessione'})
)(UsersListContainer);

UsersListContainer.defaultProps = {};

UsersListContainer.propTypes = {};
